function clearOcalisStorage() {
  chrome.storage.local.remove(["commentedPosts", "likedPosts"], () => {
    //console.log("✅ Storage Ocalis vidé");
  });
}
// ===== IndexedDB =====
chrome.runtime.onInstalled.addListener(() => {
  purgeIndexedDB();
  injectContentScriptToAllLinkedInTabs();
  clearOcalisStorage();
});

function purgeIndexedDB() {
  const req = indexedDB.deleteDatabase("OcalisDB");
  req.onsuccess = () => console.log("✅ IndexedDB purgé");
  req.onerror = () => console.error("❌ Erreur purge DB", req.error);
  req.onblocked = () => console.warn("⚠️ Purge DB bloquée");
}

// ===== Injection content script =====
const injectedTabs = new Set(); // Pour éviter les doublons

function injectContentScript(tabId) {
  if (injectedTabs.has(tabId)) return; // déjà injecté
  chrome.scripting.executeScript({
    target: { tabId },
    files: ["content.js"]
  })
  .then(() => {
    //console.log(`✅ content script injecté dans l'onglet ${tabId}`);
    injectedTabs.add(tabId);
  })
  .catch(err => console.error("❌ Injection content script:", err));
}

function injectContentScriptToAllLinkedInTabs() {
  chrome.tabs.query({ url: "*://*.linkedin.com/*" }, (tabs) => {
    for (let tab of tabs) injectContentScript(tab.id);
  });
}

// ===== Surveiller les onglets LinkedIn =====
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (changeInfo.status === "complete" && tab.url && tab.url.includes("linkedin.com")) {
    injectContentScript(tabId);
  }
});

chrome.tabs.onRemoved.addListener((tabId) => {
  // Nettoyer le Set si onglet fermé
  injectedTabs.delete(tabId);
});

// ===== Messages =====
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === "log") {
    const prefix = message.prefix || "[LOG]";
    //console.log(prefix, message.data);
    sendResponse({ status: "ok" });
  }
});
