﻿  if (window.ocalisContentInjected) {
  console.log("content.js déjà  injecté, on stoppe");
} else {
  window.ocalisContentInjected = true;

  (() => {
  let stopRequested = false;
  let currentProfileData = {};
  // Try initialize from stored persona if active
  try {
    chrome.storage.local.get(['persona','persona_active'], (st) => {
      if (st && st.persona && st.persona_active) {
        try { currentProfileData = personaToProfileData(st.persona.persona); } catch {}
      }
    });
    chrome.storage.onChanged.addListener((changes, area) => {
      if (area === 'local' && (changes.persona || changes.persona_active)) {
        chrome.storage.local.get(['persona','persona_active'], (st) => {
          if (st && st.persona && st.persona_active) {
            try { currentProfileData = personaToProfileData(st.persona.persona); } catch {}
          }
        });
      }
    });
  } catch {}

  function openDB(storeName) {
    return new Promise((resolve, reject) => {
      // bump version to 2 to add repliedComments store
      const request = indexedDB.open("OcalisDB", 2);

      request.onupgradeneeded = (event) => {
        const db = event.target.result;
        if (!db.objectStoreNames.contains("commentedPosts")) {
          db.createObjectStore("commentedPosts");
        }
        if (!db.objectStoreNames.contains("likedPosts")) {
          db.createObjectStore("likedPosts");
        }
        if (!db.objectStoreNames.contains("repliedComments")) {
          db.createObjectStore("repliedComments");
        }
      };

      request.onsuccess = () => resolve(request.result);
      request.onerror = () => reject(request.error);
    });
  }

  function addKey(storeName, key) {
    return openDB(storeName).then((db) => {
      return new Promise((resolve, reject) => {
        const tx = db.transaction(storeName, "readwrite");
        tx.objectStore(storeName).put(true, key);
        tx.oncomplete = () => resolve(true);
        tx.onerror = () => reject(tx.error);
      });
    });
  }

  function hasKey(storeName, key) {
    return openDB(storeName).then((db) => {
      return new Promise((resolve, reject) => {
        const tx = db.transaction(storeName, "readonly");
        const req = tx.objectStore(storeName).get(key);
        req.onsuccess = () => resolve(!!req.result);
        req.onerror = () => reject(req.error);
      });
    });
  }

  const addCommented = (key) => addKey("commentedPosts", key);
  const hasCommented = (key) => hasKey("commentedPosts", key);
  const addLiked = (key) => addKey("likedPosts", key);
  const hasLiked = (key) => hasKey("likedPosts", key);
  const addReplied = (key) => addKey("repliedComments", key);
  const hasReplied = (key) => hasKey("repliedComments", key);

  function hashString(str) {
    let hash = 0;
    for (let i = 0; i < str.length; i++) {
      hash = (hash << 5) - hash + str.charCodeAt(i);
      hash |= 0;
    }
    return hash;
  }

  function isSponsoredPost(p) {
    const txt = p.innerText.toLowerCase();
    const patterns = [
      /post sponsorisé/,
      /sponsored/,
      /promoted/,
      /contenu sponsorisé/,
      /partenariat rémunéré/
    ];
    
    return patterns.some((regex) => regex.test(txt));
  }
  
  // Best-effort name detection across all pages (nav menu first)
  async function getMyLinkedInNameBest() {
    const clean = (s) => (s || '').replace(/\s+/g,' ').trim();
    const looksValid = (s) => {
      const t = (s || '').toLowerCase();
      if (!t) return false;
      if (/\b(vous|you|me|moi)\b/.test(t)) return false;
      return /\w+\s+\w+/.test(s);
    };

    // 1) avatar alt in global nav
    try {
      const img = document.querySelector('img.global-nav__me-photo, img[alt][class*="global-nav__me"]');
      const alt = clean(img && img.getAttribute('alt'));
      if (looksValid(alt)) return alt;
    } catch {}

    // 2) open Me dropdown and parse
    try {
      const meBtn = document.querySelector('button.global-nav__me, .global-nav__me button[aria-expanded]');
      if (meBtn && meBtn.getAttribute('aria-expanded') !== 'true') {
        meBtn.click();
        await new Promise(r => setTimeout(r, 400));
      }
      const a = document.querySelector('div[role="menu"] a[href*="/in/"][aria-label], .global-nav__me-content a[href*="/in/"][aria-label]');
      if (a) {
        const lab = clean(a.getAttribute('aria-label'));
        const m = lab.match(/de\s+(.+)$/i) || lab.match(/of\s+(.+)$/i);
        if (m && looksValid(m[1])) return clean(m[1]);
      }
      const cand = document.querySelector('div[role="menu"] h3, div[role="menu"] .t-16, .global-nav__me-content h3, .global-nav__me-content .t-16');
      if (cand) {
        const txt = clean(cand.textContent || '');
        if (looksValid(txt)) return txt;
      }
    } catch {}

    // 3) recent-activity page title
    try {
      if (/recent-activity/.test(location.href)) {
        const t = (document.title || '').trim();
        const m = t.match(/^[^|]*\|\s*([^|]+?)\s*\|/);
        if (m && looksValid(m[1])) return m[1].trim();
      }
    } catch {}

    // 4) profile-card header
    try {
      const h3 = document.querySelector('h3.profile-card-name.text-heading-large');
      const txt = clean(h3 ? h3.textContent : '');
      if (looksValid(txt)) return txt;
    } catch {}

    return '';
  }

  const getMyLinkedInNameExact = async () => {
      try {
        const h3 = document.querySelector('h3.profile-card-name.text-heading-large');
        const txt = h3 ? (h3.textContent || '').trim() : '';
        if (txt) return txt;
      } catch {}
      try {
        if (/recent-activity/.test(location.href)) {
          const t = (document.title || '').trim();
          // e.g., "Activité | John Doe | LinkedIn"
          const m = t.match(/^[^|]*\|\s*([^|]+?)\s*\|/);
          if (m && m[1]) return m[1].trim();
        }
      } catch {}
      // fallback to stored user (avoids "Vous")
      return new Promise(resolve => {
        chrome.storage.local.get(['user'], st => {
          const n = st && st.user && st.user.name;
          resolve((n || '').trim());
        });
      });
    };

    const norm = (s) => (s || '').normalize('NFD').replace(/[\u0300-\u036f]/g,'').replace(/\s+/g, ' ').trim().toLowerCase();

    async function waitForRecentActivityHydrated(timeoutMs = 7000) {
      const start = Date.now();
      console.log('[AutoReplySniper] Waiting for recent-activity DOM to hydrate...');
      while (Date.now() - start < timeoutMs) {
        if (stopRequested) throw new Error('STOP');
        const onRa = /recent-activity/.test(location.href);
        const posts = document.querySelectorAll('.feed-shared-update-v2, .occludable-update, article').length;
        const ready = document.readyState === 'complete';
        if (onRa && ready && posts > 0) {
          console.log(`[AutoReplySniper] recent-activity ready. posts=${posts}`);
          return true;
        }
        await sleepStoppable(250);
      }
      console.warn('[AutoReplySniper] Timeout waiting recent-activity. Continuing best-effort.');
      return false;
    }

    const findOpenReplyButtonIn = (scope) => {
      const candidates = Array.from(scope.querySelectorAll('button, a, [role="button"]'));
      for (const el of candidates) {
        const spans = el.querySelectorAll('span[aria-hidden="true"]');
        for (const sp of spans) { if (norm(sp.textContent) === 'Répondre') return el; }
      }
      return null;
    };

    const findSendReplyButtonIn = (scope) => {
      const btn = Array.from(scope.querySelectorAll('button, [role="button"]')).find(b =>
        Array.from(b.querySelectorAll('span.artdeco-button__text')).some(sp => norm(sp.textContent) === 'Répondre')
      );
      return btn || null;
    };

    const getCommenterName = (commentEl) => {
      const n = commentEl.querySelector('span.comments-comment-meta__description-title');
      return (n && (n.textContent || '').trim()) || '';
    };

    const getCommentBodyText = (commentEl) => {
      const body = commentEl.querySelector('span.comments-comment-item__main-content')
        || commentEl.querySelector('.update-components-text.relative span[dir="ltr"]')
        || commentEl.querySelector('.update-components-text.relative')
        || commentEl;
      return (body && (body.textContent || '').trim()) || '';
    };

    const findRepliesCountButton = (myCommentEl) => {
      const span = myCommentEl.querySelector('button span.comments-comment-social-bar__replies-count--cr-lix-enabled');
      return span ? span.closest('button') : null;
    };

    // Stable unique key for a comment (author + body), avoids dynamic counts
    const stableCommentKey = (el) => {
      try {
        const a = norm(getCommenterName(el));
        const b = norm(getCommentBodyText(el));
        return hashString(`${a}::${b}`);
      } catch { return hashString((el && (el.innerText||'')).slice(0,300)); }
    };

    // Check if a thread already contains a reply by me
    const threadHasMyReply = (baseEl, myName) => {
      try {
        const replies = Array.from(baseEl.querySelectorAll('.comments-comment-entity.comments-comment-entity--reply'));
        return replies.some(r => norm(getCommenterName(r)) === norm(myName));
      } catch { return false; }
    };

    const getCommentsContainerForPost = (postEl) => {
      // Prefer a comments list nested under this post
      let list = postEl.querySelector('.comments-comments-list');
      if (list) return list;
      // Fallback: pick the nearest list by geometry
      try {
        const postRect = postEl.getBoundingClientRect();
        let best = null; let bestDist = Infinity;
        for (const l of Array.from(document.querySelectorAll('.comments-comments-list'))) {
          const r = l.getBoundingClientRect();
          const dist = Math.abs(r.top - postRect.bottom);
          if (r.top > (postRect.top - 300) && dist < bestDist) { best = l; bestDist = dist; }
        }
        return best;
      } catch { return null; }
    };

    // Ensure the comments list is sorted by "Most recent" (Les plus récents)
    async function ensureCommentsSortedRecent(scope) {
      try {
        const container = (scope && (scope.querySelector('.comments-sort-order-toggle__dropdown')
                          || scope.querySelector('.comments-sort-order-toggle'))) || null;
        const root = container || scope || document;
        const trigger = root.querySelector('.comments-sort-order-toggle__trigger, .comments-sort-order-toggle button.artdeco-dropdown__trigger');
        if (!trigger) return false;

        const current = norm(trigger.innerText || '');
        if (/\b(recents|plus recents|most recent|recent|newest)\b/.test(current)) {
          return true; // already on recent
        }

        await scrollToElement(trigger);
        trigger.click();
        await sleepStoppable(300);

        // Dropdown content where options are rendered dynamically
        const content = (container && container.querySelector('.comments-sort-order-toggle__content'))
                     || root.querySelector('.comments-sort-order-toggle__content')
                     || root;

        let option = null;
        for (let i = 0; i < 10 && !option; i++) {
          if (stopRequested) throw new Error('STOP');
          const candidates = Array.from(content.querySelectorAll('button, .artdeco-dropdown__item, [role="option"], li, a'));
          option = candidates.find(el => /\b(recents|plus recents|most recent|recent|newest)\b/.test(norm(el.innerText || '')));
          if (!option) await sleepStoppable(150);
        }
        if (option) {
          option.click();
          await sleepStoppable(300);
          return true;
        }
      } catch {}
      return false;
    }

  const waitForEditor = async (scope, timeoutMs = 5000) => {
      const started = Date.now();
      while (Date.now() - started < timeoutMs) {
        if (stopRequested) throw new Error('STOP');
        const ed = scope.querySelector("div[role='textbox']");
        if (ed) return ed;
        await sleepStoppable(150);
      }
      return null;
  };

  // Nearest reply composer form (avoid top-level composer)
  function findNearestReplyForm(fromEl, postEl) {
    try {
      const scope = postEl || document;
      const fromRect = fromEl.getBoundingClientRect();
      const forms = Array.from(scope.querySelectorAll('form.comments-comment-box__form'));
      let best = null; let bestDist = Infinity;
      for (const f of forms) {
        const r = f.getBoundingClientRect();
        const visible = r.height > 0 && r.width > 0;
        if (!visible) continue;
        if (r.top < fromRect.top - 40) continue;
        const dist = Math.abs(r.top - fromRect.bottom);
        if (dist < bestDist) { bestDist = dist; best = f; }
      }
      return best;
    } catch { return null; }
  }

  async function waitForReplyFormNear(fromEl, postEl, timeoutMs = 5000) {
    const start = Date.now();
    let form = null;
    while (Date.now() - start < timeoutMs) {
      if (stopRequested) throw new Error('STOP');
      form = findNearestReplyForm(fromEl, postEl);
      if (form) return form;
      await sleepStoppable(150);
    }
    return null;
  }

    // Accent-insensitive versions for reply detection
    const findOpenReplyButtonIn2 = (scope) => {
      // Prefer the explicit reply action class when present
      const byClass = scope.querySelector('button.comments-comment-social-bar__reply-action-button--cr, .comments-comment-social-bar__reply-action');
      if (byClass) return byClass;
      // Fallback: find a control with aria-hidden Répondre text
      const candidates = Array.from(scope.querySelectorAll('button, a, [role="button"]'));
      for (const el of candidates) {
        const spans = el.querySelectorAll('span[aria-hidden="true"]');
        for (const sp of spans) { if (norm(sp.textContent) === 'repondre') return el; }
      }
      return null;
    };

    const findSendReplyButtonIn2 = (scope) => {
      // Prefer exact LinkedIn submit text
      const btn = Array.from(scope.querySelectorAll('button, [role="button"]')).find(b =>
        Array.from(b.querySelectorAll('span.artdeco-button__text')).some(sp => norm(sp.textContent) === 'repondre')
      );
      if (btn) return btn;
      // Fallback: any button with visible text "Répondre"
      return Array.from(scope.querySelectorAll('button, [role="button"]')).find(b => /\brepondre\b/.test(norm(b.innerText || '')) ) || null;
    };

    const getPostMainText = (postEl) => {
      try {
        const pick = (root) => {
          return root.querySelector(
            '[data-test-id="post-content"], .feed-shared-update-v2__description, .feed-shared-text, .update-components-text.relative, .update-components-text, .feed-shared-text-view__text-view'
          ) || root;
        };
        const scope = pick(postEl || document);
        const span = scope.querySelector('span[dir="ltr"], .break-words');
        let txt = (span && span.textContent) || scope.textContent || '';
        txt = (txt || '').replace(/\s+/g, ' ').trim();

        // Fallbacks for media-only posts: use image alt text and visible captions
        if (!txt || txt.length < 20) {
          const alts = Array.from(scope.querySelectorAll('img[alt]'))
            .map(img => (img.getAttribute('alt') || '').trim())
            .filter(Boolean);
          const joined = alts.join(' ').replace(/\s+/g,' ').trim();
          if (joined && joined.length > txt.length) txt = joined;
        }

        // Last-resort: take limited text from the full post element
        if ((!txt || txt.length < 20) && postEl) {
          const raw = (postEl.innerText || postEl.textContent || '').replace(/\s+/g,' ').trim();
          if (raw) txt = raw.slice(0, 800);
        }
        return txt;
      } catch { return ''; }
    };

    const replyToComment = async (commentEl, postEl, bodyDataProfile, overrideText, options = {}) => {
      const shouldSubmit = options.submit !== false;
      const contentToUse = overrideText || getCommentBodyText(commentEl) || (commentEl.innerText || '');
      const postMainText = getPostMainText(postEl);
      const hash = stableCommentKey(commentEl);
      if (await hasReplied(hash)) { console.log('[AutoReplySniper] Skip (already replied)'); return false; }

      let formNear = findNearestReplyForm(commentEl, postEl);
      if (!formNear) {
        const openBtn = findOpenReplyButtonIn2(commentEl);
        if (!openBtn) { console.warn('[AutoReplySniper] Open-reply button not found'); return false; }
        await scrollToElement(openBtn);
        openBtn.click();
        await sleepStoppable(300);
        formNear = await waitForReplyFormNear(commentEl, postEl, 4000);
      }
      
      const editor = formNear && (formNear.querySelector('div[role="textbox"], .ql-editor[contenteditable="true"]'))
                  || await waitForEditor(commentEl);
      if (!editor) { console.warn('[AutoReplySniper] Editor not found after opening reply (near comment)'); return false; }

      console.log(`[AutoReplySniper] comment content : ${contentToUse}`);
      
      const bodyData = { comment: contentToUse, post: postMainText, profile: bodyDataProfile, mode: 'reply' };
      const resp = await apiFetchContent('/reply', { method: 'POST', body: JSON.stringify(bodyData) });

      const data = await resp.json();

      if (!resp.ok) {
        if (data.error === "quota_reached") {
          chrome.storage.local.set({ quota: data.quota_restant, mode: data.mode });
          console.log("[Auto Reply] Quota journalier atteint :", data.quota_restant);
          throw new Error("STOP");
        }
          throw new Error(
                "Vérifiez si vous êtes connecté(e) à  Ocalis. Sinon, veuillez contacter l'administrateur."
          );
        }

      if (data.unlimited) {
        if (data.mode === "free_trial") {
          chrome.storage.local.set({ quota: "illimité (essai gratuit)", mode: data.mode });
          console.log("[Auto Reply] Quota illimité pendant l'essai gratuit");
        } else if (data.mode === "gold_unlimited") {
          chrome.storage.local.set({ quota: "illimité", mode: data.mode });
          console.log("[Auto Reply] Quota illimité");
        }
      } else {
        chrome.storage.local.set({ quota: data.quota_restant, mode: data.mode });
        console.log("[Auto Reply] Quota restant :", data.quota_restant);
      }

      const replyText = normalizeComment(data.reply || data.comment || '');
      console.log(`[AutoReplySniper] Typing generated reply (${replyText.length} chars)`);
      editor.focus();
      try {
        const getPlain = (el) => (el.innerText || el.textContent || '');
        const existing = getPlain(editor);
        const sep = existing && !/\s$/.test(existing) ? ' ' : '';
        if (window.getSelection && document.createRange) {
          const sel = window.getSelection();
          const range = document.createRange();
          range.selectNodeContents(editor);
          range.collapse(false); // caret at end
          sel.removeAllRanges();
          sel.addRange(range);
          if (document.execCommand) {
            document.execCommand('insertText', false, sep + replyText);
          } else {
            editor.appendChild(document.createTextNode(sep + replyText));
          }
        } else {
          editor.appendChild(document.createTextNode(sep + replyText));
        }
      } catch (e) {
        // Fallback: append to existing textContent
        editor.textContent = ((editor.textContent || '') + ' ' + replyText).trim();
      }
      editor.dispatchEvent(new Event('input', { bubbles: true }));
      await sleepStoppable(250);

      if (!shouldSubmit) {
        return true;
      }

      // Prefer the submit button INSIDE the active reply form to avoid clicking the social bar "Répondre"
      let form = formNear || (editor && editor.closest('form.comments-comment-box__form'))
              || commentEl.closest && commentEl.closest('form.comments-comment-box__form')
              || (postEl && postEl.querySelector('form.comments-comment-box__form'))
              || null;
      let submit = null;
      if (form) {
        submit = Array.from(form.querySelectorAll('button, [role="button"]')).find(b => {
          const t = (b.innerText || '').normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim().toLowerCase();
          const hasTextSpan = Array.from(b.querySelectorAll('span.artdeco-button__text')).some(sp => (sp.textContent || '').normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim().toLowerCase() === 'repondre');
          const isReplyOpenAction = /comments-comment-social-bar__reply-action/i.test(b.className || '');
          return !isReplyOpenAction && (hasTextSpan || /^repondre$/.test(t));
        }) || form.querySelector('button[type="submit"]');
        if (!submit) {
          for (let i=0;i<6 && !submit;i++) {
            await sleepStoppable(200);
            submit = Array.from(form.querySelectorAll('button, [role="button"]')).find(b => {
              const t = (b.innerText || '').normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim().toLowerCase();
              const hasTextSpan = Array.from(b.querySelectorAll('span.artdeco-button__text')).some(sp => (sp.textContent || '').normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim().toLowerCase() === 'repondre');
              const isReplyOpenAction = /comments-comment-social-bar__reply-action/i.test(b.className || '');
              return !isReplyOpenAction && (hasTextSpan || /^repondre$/.test(t));
            }) || form.querySelector('button[type="submit"]');
          }
        }
      }
      if (!submit) {
        // Fallback: restrict search to post area but exclude social bar reply-action
        const scope = postEl || document;
        submit = Array.from(scope.querySelectorAll('form.comments-comment-box__form button, form.comments-comment-box__form [role="button"]')).find(b => {
          const t = (b.innerText || '').normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim().toLowerCase();
          const hasTextSpan = Array.from(b.querySelectorAll('span.artdeco-button__text')).some(sp => (sp.textContent || '').normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim().toLowerCase() === 'repondre');
          const isReplyOpenAction = /comments-comment-social-bar__reply-action/i.test(b.className || '');
          return !isReplyOpenAction && (hasTextSpan || /^repondre$/.test(t));
        }) || findSendReplyButtonIn2(commentEl) || findSendReplyButtonIn2(postEl);
      }
      if (!submit) { console.warn('[AutoReplySniper] Submit button (Répondre) not found'); return false; }
      await scrollToElement(submit);
      submit.click();
      console.log('[AutoReplySniper] Submitted reply');
      await sleepStoppable(500);
      await addReplied(hash);
      console.log('[AutoReplySniper] Marked comment as replied');
      return true;
    };

    function getReplyBodyText(replyEl) {
      try { return getCommentBodyText(replyEl); } catch { return (replyEl && (replyEl.innerText || '').trim()) || ''; }
    }


  // --- Auto Comment ---
  async function autoCommentPosts(count = 0, profileData = {}) {
    console.log("autoCommentPosts, count =", count);
    let commented = 0;
    let postIndex = 0;

    try {
      while (commented < count) {
        if (stopRequested) throw new Error("STOP");

        const posts = document.querySelectorAll(".feed-shared-update-v2, .occludable-update");
        if (posts.length === 0) {
          console.log("Pas de posts visibles, scroll...");
          await humanLikeStepScroll();
          await sleepStoppable(1500);
          continue;
        }

        for (; postIndex < posts.length && commented < count; postIndex++) {
          if (stopRequested) throw new Error("STOP");
          const post = posts[postIndex];

          if (isSponsoredPost(post)) {
            console.log(`Poste ${postIndex} ignoré (pub).`);
            continue;
          }

          const postLink = post.querySelector('a[href*="/feed/update/"]')?.href;
          const postHash = hashString(post.innerText.slice(0, 500));
          const key = postLink || postHash;

          if (await hasCommented(key)) continue;

          try {
            let didOpenForCheck = false;
            let commentButton =
              post.querySelector('button[aria-label*="Comment"]') ||
              post.querySelector('button[aria-label*="Commenter"]') ||
              post.querySelector('button[data-control-name="comment"]');

            try {
              const myName = await getMyLinkedInNameBest();
              if (myName) {
                let listPre = getCommentsContainerForPost(post);
                if (!listPre && commentButton) { try { commentButton.click(); await sleepStoppable(500); didOpenForCheck = true; } catch {} listPre = getCommentsContainerForPost(post); }
                if (listPre) {
                  const topComments = Array.from(listPre.querySelectorAll('.comments-comment-entity')).filter(el => !el.classList.contains('comments-comment-entity--reply'));
                  let shouldSkip = false;
                  for (const c of topComments) {
                    const author = getCommenterName(c);
                    if (author && norm(author) === norm(myName)) { console.log('[AutoComment] Already commented this post, skipping'); shouldSkip = true; break; }
                    if (threadHasMyReply(c, myName)) { console.log('[AutoComment] Already replied in this thread, skipping'); shouldSkip = true; break; }
                  }
                  if (shouldSkip) continue;
                }
              }
            } catch {}

            if (commentButton && !didOpenForCheck) {
              commentButton.click();
              await sleepStoppable(700);
            }

            const textarea = post.querySelector("form.comments-comment-box__form div[role='textbox']");
            if (!textarea) continue;

            const postText = post.innerText || "";
            const bodyData = { post: postText, profile: profileData };

            const resp = await apiFetchContent("/comment", {
              method: "POST",
              body: JSON.stringify(bodyData),
            });

            const data = await resp.json();

            if (!resp.ok) {
              // Quota dépassé
              if (data.error === "quota_reached") {
                chrome.storage.local.set({ quota: data.quota_restant, mode: data.mode });
                console.log("[Auto Comment] Quota journalier atteint :", data.quota_restant);
                throw new Error("STOP");
              }

              throw new Error(
                "Vérifiez si vous êtes connecté(e) à  Ocalis. Sinon, veuillez contacter l'administrateur."
              );
            }

            // Gestion quotas + mode
            if (data.unlimited) {
              if (data.mode === "free_trial") {
                chrome.storage.local.set({ quota: "illimité (essai gratuit)", mode: data.mode });
                console.log("[Auto Comment] Quota illimité pendant l'essai gratuit");
              } else if (data.mode === "gold_unlimited") {
                chrome.storage.local.set({ quota: "illimité", mode: data.mode });
                console.log("[Auto Comment] Quota illimité (gold)");
              }
            } else {
              chrome.storage.local.set({ quota: data.quota_restant, mode: data.mode });
              console.log("[Auto Comment] Quota restant :", data.quota_restant);
            }

            const rawComment = data.comment || "";
            const comment = normalizeComment(rawComment);

            textarea.focus();
            textarea.textContent = comment;
            textarea.dispatchEvent(new Event("input", { bubbles: true }));
            await sleepStoppable(500);

            const submit = getSubmitButton(post);
            if (submit) {
              submit.click();
              commented++;
              await addCommented(key);
              console.log(`Commenté (${commented}/${count})`);
              await sleepStoppable(1500);
            }
              
          } catch (e) {
            if (e.message === "STOP") {
              console.log("autoCommentPosts stoppé");
              return commented;
            } else throw e;
          }
        }

        if (commented < count) {
          postIndex = 0;
          await humanLikeStepScroll();
          await sleepStoppable(1500);
        }
      }
    } catch (e) {
      if (e.message === "STOP") {
        console.log("autoCommentPosts stoppé");
        return commented;
      } else throw e;
    }

    console.log("Fini, total commentés :", commented);
    return commented;
  }

  // --- Auto Like ---
  async function autoLikePosts(count = 0) {
    console.log("autoLikePosts, count =", count);

    const selectors = await getLikeSelectors();
    if (!selectors.length) return;

    let liked = 0;
    let postIndex = 0;

    try {
      while (liked < count) {
        if (stopRequested) throw new Error("STOP");

        const posts = document.querySelectorAll(".feed-shared-update-v2, .occludable-update");

        if (posts.length === 0) {
          console.log("Pas de posts visibles, scroll...");
          await humanLikeStepScroll();
          await sleepStoppable(1500);
          continue;
        }

        for (; postIndex < posts.length && liked < count; postIndex++) {
          if (stopRequested) throw new Error("STOP");
          const post = posts[postIndex];

          const postLink = post.querySelector('a[href*="/feed/update/"]')?.href;
          const postHash = hashString(post.innerText.slice(0, 500));
          const key = postLink || postHash;

          if (await hasLiked(key)) {
            continue;
          }

          let btn = null;
          for (let sel of selectors) {
            btn = post.querySelector(sel);
            if (btn) break;
          }
          if (!btn) {
            console.log("Bouton Like introuvable");
            continue;
          }

          const already = btn.getAttribute("aria-pressed") === "true" ||
                          btn.classList.contains("react-button--active");

          if (already) {
            continue;
          }

          if (await clickIfVisible(btn)) {
            liked++;
            await addLiked(key);
            console.log(`Liked (${liked}/${count})`);
            await sleepStoppable(1200 + Math.random() * 800);
          }
        }

        if (liked < count) {
          console.log("Scroll pour charger plus de posts...");
          postIndex = 0;
          await humanLikeStepScroll();
          await sleepStoppable(1500);
        }
      }
    } catch (e) {
      if (e.message === "STOP") {
        console.log("autoLikePosts stoppé");
        return liked;
      } else throw e;
    }

    console.log("Fini autoLikePosts, total likés :", liked);
    return liked;
  }


  // --- Auto Like + Comment ---
  async function autoLikeCommentPosts(count = 0, profileData = {}) {
    console.log("autoLikeCommentPosts", count, profileData);

    const likeSelectors = await getLikeSelectors();
    if (!likeSelectors.length) {
      return 0;
    }

    let done = 0;
    let postIndex = 0;

    try {
      while (done < count) {
        if (stopRequested) throw new Error("STOP");

        const posts = document.querySelectorAll(".feed-shared-update-v2, .occludable-update");
        if (posts.length === 0) {
          console.log("Pas de posts visibles, scroll...");
          await humanLikeStepScroll();
          await sleepStoppable(1500);
          continue;
        }

        for (; postIndex < posts.length && done < count; postIndex++) {
          if (stopRequested) throw new Error("STOP");
          const post = posts[postIndex];

          if (isSponsoredPost(post)) {
            console.log(`Poste ${postIndex} ignoré (pub).`);
            continue;
          }

          const postLink = post.querySelector('a[href*="/feed/update/"]')?.href;
          const postHash = hashString(post.innerText.slice(0, 500));
          const key = postLink || postHash;

          if (await hasCommented(key) || await hasLiked(key)) continue;

          try {
            // --- Like ---
            let btn = null;
            for (let sel of likeSelectors) {
              btn = post.querySelector(sel);
              if (btn) break;
            }

            const alreadyLiked = btn && (btn.getAttribute("aria-pressed") === "true" || btn.classList.contains("react-button--active"));
            if (btn && !alreadyLiked) {
              if (await clickIfVisible(btn)) {
                console.log(`Post liké (${done + 1}/${count})`);
                await sleepStoppable(1000 + Math.random() * 1000);
              }
            }

            // --- Comment ---
            const commentButton =
              post.querySelector('button[aria-label*="Comment"]') ||
              post.querySelector('button[aria-label*="Commenter"]') ||
              post.querySelector('button[data-control-name="comment"]');

            let didOpenForCheck2 = false;
            try {
              const myName2 = await getMyLinkedInNameBest();
              if (myName2) {
                let listPre2 = getCommentsContainerForPost(post);
                if (!listPre2 && commentButton) { try { commentButton.click(); await sleepStoppable(500); didOpenForCheck2 = true; } catch {} listPre2 = getCommentsContainerForPost(post); }
                if (listPre2) {
                  const topComments2 = Array.from(listPre2.querySelectorAll('.comments-comment-entity')).filter(el => !el.classList.contains('comments-comment-entity--reply'));
                  let shouldSkip2 = false;
                  for (const c of topComments2) {
                    const author = getCommenterName(c);
                    if (author && norm(author) === norm(myName2)) { console.log('[AutoLikeComment] Already commented this post, skipping'); shouldSkip2 = true; break; }
                    if (threadHasMyReply(c, myName2)) { console.log('[AutoLikeComment] Already replied in this thread, skipping'); shouldSkip2 = true; break; }
                  }
                  if (shouldSkip2) { await sleepStoppable(200); continue; }
                }
              }
            } catch {}

            if (commentButton && !didOpenForCheck2) {
              commentButton.click();
              await sleepStoppable(700 + Math.random() * 500);
            }

            const textarea = post.querySelector("form.comments-comment-box__form div[role='textbox']");
            if (textarea) {
              const postText = post.innerText || "";
              const bodyData = { post: postText, profile: profileData };

              const resp = await apiFetchContent("/comment", {
                method: "POST",
                body: JSON.stringify(bodyData),
              });

              const data = await resp.json();

              if (!resp.ok) {
                // Quota dépassé
                if (data.error === "quota_reached") {
                  chrome.storage.local.set({ quota: data.quota_restant, mode: data.mode });
                  console.log("[Auto Comment] Quota journalier atteint :", data.quota_restant);
                  throw new Error("STOP");
                }

                throw new Error(
                  "Vérifiez si vous êtes connecté(e) à  Ocalis. Sinon, veuillez contacter l'administrateur."
                );
              }

              // Gestion quotas + mode
              if (data.unlimited) {
                if (data.mode === "free_trial") {
                  chrome.storage.local.set({ quota: "illimité (essai gratuit)", mode: data.mode });
                  console.log("[Auto Comment] Quota illimité pendant l'essai gratuit");
                } else if (data.mode === "gold_unlimited") {
                  chrome.storage.local.set({ quota: "illimité", mode: data.mode });
                  console.log("[Auto Comment] Quota illimité (gold)");
                }
              } else {
                chrome.storage.local.set({ quota: data.quota_restant, mode: data.mode });
                console.log("Quota restant :", data.quota_restant);
              }

              const rawComment = data.comment || "";
              const comment = normalizeComment(rawComment);
  
              textarea.focus();
              textarea.textContent = comment;
              textarea.dispatchEvent(new Event("input", { bubbles: true }));
              await sleepStoppable(600 + Math.random() * 400);

              const submit = getSubmitButton(post);
              if (submit) {
                submit.click();
                done++;
                await addLiked(key);
                await addCommented(key);
                console.log(`Commenté + Liké (${done}/${count})`);
                await sleepStoppable(1500 + Math.random() * 1000);
              }
                
            }

            await humanLikeStepScroll();
          } catch (e) {
            if (e.message === "STOP") {
              console.log("autoLikeCommentPosts stoppé");
              return done;
            } else throw e;
          }
        }

        if (done < count) {
          postIndex = 0;
          console.log("Scroll pour charger plus...");
          await humanLikeStepScroll();
          await sleepStoppable(1500);
        }
      }
    } catch (e) {
      if (e.message === "STOP") {
        console.log("autoLikeCommentPosts stoppé");
        return done;
      } else throw e;
    }

    console.log("Fini, total like+comment :", done);
    return done;
  }

  function waitForElement(parent, selector, timeout = 3000) {
    return new Promise(res => {
      const el = parent.querySelector(selector);
      if (el) return res(el);

      const observer = new MutationObserver(() => {
        const found = parent.querySelector(selector);
        if (found) {
          observer.disconnect();
          res(found);
        }
      });

      observer.observe(parent, { childList: true, subtree: true });
      setTimeout(() => {
        observer.disconnect();
        res(null);
      }, timeout);
    });
  }

  async function humanLikeStepScroll() {
    if (stopRequested) throw new Error("STOP");
    const totalDistance = Math.floor(Math.random() * 200) + 300; 
    const steps = Math.floor(Math.random() * 10) + 15; // 15â€“25 mini-steps
    const stepDistance = totalDistance / steps;

    for (let i = 0; i < steps; i++) {
      window.scrollBy({
        top: stepDistance,
        left: 0,
        behavior: "smooth",
      });

      const pause = Math.floor(Math.random() * 100) + 50;
      await new Promise(r => setTimeout(r, pause));
    }

    const finalPause = Math.floor(Math.random() * 800) + 400; // 0.4â€“1.2s
    await new Promise(r => setTimeout(r, finalPause));

    const newPostsButton = Array.from(document.querySelectorAll("button.artdeco-button"))
      .find(btn =>
        btn.innerText.trim() === "Voir les nouveaux posts" ||
        btn.innerText.trim() === "Voir plus de nouvelles actualités" ||
        btn.innerText.trim() === "See new posts"
      );

    if (newPostsButton) {
      console.log("ðŸ”” Clic sur le bouton \"Voir les nouveaux posts\" ...");
      newPostsButton.click();

      await new Promise(r => setTimeout(r, 1500));
    }

    console.log(`Scrolling .....`);
  }

  async function scrollToElement(el) {
    if (!el) return false;

    function isInViewport(element) {
      const rect = element.getBoundingClientRect();
      return rect.top >= 0 && rect.bottom <= window.innerHeight;
    }

    let safety = 0;
    while (!isInViewport(el) && safety < 30) {
      safety++;

      const rect = el.getBoundingClientRect();
      const targetY = rect.top + window.scrollY - window.innerHeight / 2;

      const currentY = window.scrollY;
      const distance = targetY - currentY;

      const step = distance * (0.2 + Math.random() * 0.2);

      window.scrollBy({
        top: step,
        left: 0,
        behavior: "smooth"
      });

      await new Promise(r => setTimeout(r, 500 + Math.random() * 800));
    }

    return true;
  }

  async function clickIfVisible(btn) {
    if (!btn) return false;
    await scrollToElement(btn);

    const rect = btn.getBoundingClientRect();
    const fullyVisible =
      rect.top >= 0 &&
      rect.left >= 0 &&
      rect.bottom <= window.innerHeight &&
      rect.right <= window.innerWidth;

    if (fullyVisible) {
      try {
        btn.click();
        return true;
      } catch (e) {
        console.warn("Impossible de cliquer sur le bouton", e);
        return false;
      }
    }
    return false;
  }

  // --- sleep stoppable ---
  async function sleepStoppable(ms) {
    const step = 100; // vérif toutes les 100ms
    let elapsed = 0;
    while (elapsed < ms) {
      if (stopRequested) throw new Error("STOP");
      await new Promise(r => setTimeout(r, step));
      elapsed += step;
    }
  }

  function getSubmitButton(post) {
    return Array.from(post.querySelectorAll("form.comments-comment-box__form button"))
      .find(btn => {
        const txt = btn.innerText.trim().toLowerCase();
        return txt === "comment" || txt === "commenter";
      });
  }

  // --- Reply Sniper helpers ---
  function getReplySubmitButton(scope) {
    return Array.from(scope.querySelectorAll("button, [role='button']"))
      .find(btn => /^(?:reply|répondre|publier|post)$/i.test((btn.innerText || '').trim()));
  }

  function getCommentLikeCount(commentEl) {
    try {
      const likeBadge = commentEl.querySelector('button[aria-pressed], .social-details-social-counts__reactions, .reactions-count, .comments-comment-social-bar__reactions-count, .v-align-middle');
      if (likeBadge) {
        const n = parseInt((likeBadge.innerText || '').replace(/\D/g, ''), 10);
        if (!isNaN(n)) return n;
      }
      const text = (commentEl.innerText || '').toLowerCase();
      const m = text.match(/(\d+[\s\u00a0]?)(?:likes?|j\'?aime|jaime|réactions?|reactions?)/i);
      if (m) {
        const n = parseInt(m[1].replace(/\D/g, ''), 10);
        if (!isNaN(n)) return n;
      }
      // fallback based on length
      const body = commentEl.querySelector('.comments-comment-item-content-body, .comments-comment-item__main-content');
      const len = (body && (body.innerText || '').length) || (commentEl.innerText || '').length;
      return Math.floor(len / 40);
    } catch { return 0; }
  }

  async function autoReplySniperLegacy(count = 1, profileData = {}) {
    const opts = (typeof arguments[2] === 'object' ? arguments[2] : {}) || {};
    const myPostsOnly = !!opts.myPostsOnly;
    const myName = await getMyLinkedInName();
    let replied = 0;

    if (myPostsOnly) {
      // Navigate to profile (best-effort)
      try { await ensureProfilePage(); await sleepStoppable(800); } catch {}
      // Try to go to recent activity page for more posts
      try {
        const href = location.href;
        if (!/recent-activity/.test(href)) {
          const u = new URL(href);
          if (!u.pathname.endsWith('/')) u.pathname += '/';
          location.assign(u.origin + u.pathname + 'recent-activity/all/');
          await sleepStoppable(1600);
        }
      } catch {}

      let noGrowth = 0; let prevH = document.body.scrollHeight;
      while (true) {
        if (stopRequested) throw new Error('STOP');
        const posts = document.querySelectorAll('.feed-shared-update-v2, .occludable-update');
        for (const post of posts) {
          if (stopRequested) throw new Error('STOP');
          // Open comments if a counter/link is present
          const openBtn = Array.from(post.querySelectorAll('button, a'))
            .find(el => /commentaires|comments/i.test((el.innerText||'')));
          if (openBtn) { openBtn.click(); await sleepStoppable(600); }

          await clickShowMoreIn(post);
          const items = Array.from(post.querySelectorAll('.comments-comment-item'));
          for (const it of items) {
            if (stopRequested) throw new Error('STOP');
            const hash = hashString((it.innerText || '').slice(0, 400));
            if (await hasReplied(hash)) continue;
            const replyBtn = it.querySelector('button[aria-label*="Répondre" i], button[aria-label*="Reply" i], button.comments-comment-social-bar__reply-action');
            if (!replyBtn) continue;
            await scrollToElement(replyBtn);
            replyBtn.click();
            await sleepStoppable(300);
            const editor = it.querySelector("div[role='textbox']");
            if (!editor) continue;
            const bodyData = { comment: it.innerText || '', profile: profileData, mode: 'reply' };
            const resp = await apiFetchContent('/comment', { method: 'POST', body: JSON.stringify(bodyData) });
            const data = await resp.json();
            if (!resp.ok) { if (data && data.error === 'quota_reached') { chrome.storage.local.set({ quota: data.quota_restant }); throw new Error('STOP'); } else throw new Error('generation_failed'); }
            chrome.storage.local.set({ quota: data.quota_restant });
            const reply = normalizeComment(data.reply || data.comment || '');
            editor.focus(); editor.textContent = reply; editor.dispatchEvent(new Event('input', { bubbles: true }));
            await sleepStoppable(300);
            const submit = getReplySubmitButton(it) || getSubmitButton(post);
            if (submit) { submit.click(); replied++; await addReplied(hash); await sleepStoppable(600); if (replied >= count) return replied; }
          }
        }
        // Scroll and stop after 5 ineffective scrolls
        await humanLikeStepScroll(); await sleepStoppable(700);
        const h = document.body.scrollHeight; if (h <= prevH) noGrowth++; else { noGrowth = 0; prevH = h; }
        if (noGrowth >= 5) break;
      }
      return replied;
    }

    // Mode: feed → reply only to replies under my own comments
    try { if (!/linkedin\.com\/feed\//.test(location.href)) { console.log('[AutoReplySniper] Navigating to /feed'); location.assign('https://www.linkedin.com/feed/'); await sleepStoppable(1500); } } catch {}
    while (true) {
      if (stopRequested) throw new Error('STOP');
      const posts = document.querySelectorAll('.feed-shared-update-v2, .occludable-update');
      for (const post of posts) {
        if (stopRequested) throw new Error('STOP');
        const openBtn = post.querySelector('button[aria-label*="Comment"], button[aria-label*="Commenter"], button[data-control-name="comment"]');
        if (openBtn) { openBtn.click(); await sleepStoppable(500); }
        await clickShowMoreIn(post);
        // Find my comments
        const items = Array.from(post.querySelectorAll('.comments-comment-item'));
        const myItems = items.filter(el => (el.innerText || '').toLowerCase().includes((myName||'').toLowerCase()));
        for (const mine of myItems) {
          if (stopRequested) throw new Error('STOP');
          // Expand replies under my comment
          await clickShowMoreIn(mine, true);
          const replies = Array.from(mine.querySelectorAll('.comments-comment-item'))
            .filter(el => !(el.innerText||'').toLowerCase().includes((myName||'').toLowerCase()));
          for (const replyEl of replies) {
            if (stopRequested) throw new Error('STOP');
            const hash = hashString((replyEl.innerText || '').slice(0, 400));
            if (await hasReplied(hash)) continue;
            const btn = replyEl.querySelector('button[aria-label*="Répondre" i], button[aria-label*="Reply" i], button.comments-comment-social-bar__reply-action');
            if (!btn) continue;
            await scrollToElement(btn); btn.click(); await sleepStoppable(300);
            const editor = replyEl.querySelector("div[role='textbox']"); if (!editor) continue;
            const bodyData = { comment: replyEl.innerText || '', profile: profileData, mode: 'reply' };
            const resp = await apiFetchContent('/comment', { method: 'POST', body: JSON.stringify(bodyData) });
            const data = await resp.json();
            if (!resp.ok) { if (data && data.error === 'quota_reached') { chrome.storage.local.set({ quota: data.quota_restant }); throw new Error('STOP'); } else throw new Error('generation_failed'); }
            chrome.storage.local.set({ quota: data.quota_restant });
            const replyText = normalizeComment(data.reply || data.comment || '');
            editor.focus(); editor.textContent = replyText; editor.dispatchEvent(new Event('input', { bubbles: true }));
            await sleepStoppable(300);
            const submit = getReplySubmitButton(replyEl) || getSubmitButton(post);
            if (submit) { submit.click(); replied++; await addReplied(hash); await sleepStoppable(600); if (replied >= count) return replied; }
          }
        }
      }
      await humanLikeStepScroll(); await sleepStoppable(900);
    }
  }

  // New stricter implementation per LinkedIn DOM for auto-replies
  async function autoReplySniper(count = 1, profileData = {}, options = {}) {
    const myPostsOnly = !!options.myPostsOnly;

    console.log(`[AutoReplySniper] Starting. count=${count}, myPostsOnly=${myPostsOnly}`);
    let myName = '';
    try { myName = await getMyLinkedInNameBest(); } catch {}
    myName = (myName || '').toString().trim();
    console.log(`[AutoReplySniper] Detected LinkedIn name: "${myName}"`);
    let replied = 0;

    if (myPostsOnly) {
      console.log('[AutoReplySniper] myPostsOnly=true → ensureProfilePage()');
      try { await ensureProfilePage(); await sleepStoppable(800); console.log('[AutoReplySniper] On profile page.'); } catch { console.warn('[AutoReplySniper] ensureProfilePage failed (continuing).'); }
      // Navigate to recent activity page to list my posts
      try {
        const href = location.href;
        if (!/recent-activity/.test(href)) {
          const u = new URL(href);
          if (!u.pathname.endsWith('/')) u.pathname += '/';
          location.assign(u.origin + u.pathname + 'recent-activity/all/');
          await sleepStoppable(1600);
        }
      } catch {}
      await waitForRecentActivityHydrated();
      let postIndex = 0;
      while (replied < count) {
        if (stopRequested) throw new Error('STOP');
        const posts = Array.from(document.querySelectorAll('.feed-shared-update-v2, .occludable-update, article'));
        console.log(`[AutoReplySniper] [MyPosts] Visible posts: ${posts.length}`);
        if (postIndex >= posts.length) {
          console.log('[AutoReplySniper] [MyPosts] No more posts in view, scrolling...');
          await humanLikeStepScroll();
          await sleepStoppable(900);
          postIndex = 0;
          continue;
        }

        const post = posts[postIndex++];
        if (isSponsoredPost(post)) continue;
        console.log(`[AutoReplySniper] [MyPosts] Processing post ${postIndex}/${posts.length}`);
        const openBtn = Array.from(post.querySelectorAll('button, a')).find(el => /commentaires|comments/i.test((el.innerText || '')));
        if (openBtn) { console.log('[AutoReplySniper] [MyPosts] Opening comments'); openBtn.click(); await sleepStoppable(700); }
        // Force comment sort to Most recent to avoid missing new replies
        try { await ensureCommentsSortedRecent(post); } catch {}
        await clickShowMoreIn(post);

        const list = getCommentsContainerForPost(post);
        if (!list) { console.warn('[AutoReplySniper] [MyPosts] No comments list found for post'); continue; }
        const comments = Array.from(list.querySelectorAll('.comments-comment-entity:not(.comments-comment-entity--reply)'));
        console.log(`[AutoReplySniper] [MyPosts] Comments found: ${comments.length}`);
        for (const c of comments) {
          if (stopRequested) throw new Error('STOP');
          const author = getCommenterName(c);
          if (author && myName && norm(author) === norm(myName)) continue;
          if (threadHasMyReply(c, myName)) { console.log('[AutoReplySniper] [MyPosts] Already replied in this thread, skipping'); continue; }
          console.log(`[AutoReplySniper] [MyPosts] Replying to author="${author || '?'}"`);
          const ok = await replyToComment(c, post, profileData);
          if (ok) { replied++; if (replied >= count) return replied; }
        }
      }
      return replied;
    }

    // Activity Comments: reply to people who replied to MY comments
    try {
      await ensureProfilePage();
      await sleepStoppable(600);
      const href = location.href;
      if (!/recent-activity\/comments\//.test(href)) {
        try {
          const u = new URL(href);
          if (!u.pathname.endsWith('/')) u.pathname += '/';
          location.assign(u.origin + u.pathname + 'recent-activity/comments/');
          await sleepStoppable(1800);
        } catch {}
      }
      await waitForRecentActivityHydrated();
    } catch {}

    while (replied < count) {
      if (stopRequested) throw new Error('STOP');
      const posts = Array.from(document.querySelectorAll('.feed-shared-update-v2, .occludable-update, article'));
      if (posts.length === 0) { console.log('[AutoReplySniper] [Activity-Comments] No posts visible, scrolling...'); await humanLikeStepScroll(); await sleepStoppable(900); continue; }

      for (const post of posts) {
        if (stopRequested) throw new Error('STOP');
        if (isSponsoredPost(post)) continue;

        const openBtn = Array.from(post.querySelectorAll('button, a')).find(el => /commentaires|comments/i.test((el.innerText || '')));
        if (openBtn) { console.log('[AutoReplySniper] [Activity-Comments] Opening comments'); openBtn.click(); await sleepStoppable(700); }
        await clickShowMoreIn(post);

        const list = getCommentsContainerForPost(post);
        if (!list) { console.warn('[AutoReplySniper] [Activity-Comments] No comments list found for post'); continue; }
        const allComments = Array.from(list.querySelectorAll('.comments-comment-entity'));
        const myComments = allComments.filter(el => norm(getCommenterName(el)) === norm(myName) && !el.classList.contains('comments-comment-entity--reply'));
        console.log(`[AutoReplySniper] [Activity-Comments] My top-level comments found: ${myComments.length}`);
        for (const mine of myComments) {
          if (stopRequested) throw new Error('STOP');
          // Expand replies first so our check can see existing replies from me
          const repliesBtn = findRepliesCountButton(mine);
          if (repliesBtn) {
            console.log('[AutoReplySniper] [Activity-Comments] Expanding replies under my comment');
            await scrollToElement(repliesBtn);
            repliesBtn.click();
            await sleepStoppable(500);
          }
          await clickShowMoreIn(mine, true);

          // After expansion, skip if I already replied anywhere in this thread
          if (threadHasMyReply(mine, myName)) { console.log('[AutoReplySniper] [Activity-Comments] Already replied under my comment, skipping'); continue; }

          const replies = Array.from(mine.querySelectorAll('.comments-comment-entity.comments-comment-entity--reply'))
            .filter(el => norm(getCommenterName(el)) !== norm(myName));
          console.log(`[AutoReplySniper] [Activity-Comments] Replies to my comment: ${replies.length}`);
          for (const r of replies) {
            if (stopRequested) throw new Error('STOP');
            const replyContent = getReplyBodyText(r);
            const ok = await replyToComment(r, post, profileData, replyContent);
            if (ok) {
              // Only one auto-reply per thread under my comment
              replied++;
              if (replied >= count) return replied;
              break;
            }
          }
        }
      }
      await humanLikeStepScroll(); await sleepStoppable(900);
    }

    return replied;
  }

  async function clickShowMoreIn(scope, repliesOnly = false) {
    const patterns = repliesOnly
      ? /(afficher|voir).*(plus|davantage).*(réponses|replies)|show more replies|view more replies/i
      : /(afficher|voir).*(plus|davantage).*(commentaires|réponses)|show more comments|show more replies|view more (comments|replies)/i;
    for (let i=0;i<4;i++) {
      const btn = Array.from(scope.querySelectorAll('button, a')).find(el => patterns.test((el.innerText||'').toLowerCase()));
      if (!btn) break; btn.click(); await sleepStoppable(500);
    }
  }

  // Override with strict selector to avoid "Vous": profile-card header name
  async function getMyLinkedInName() {
    try {
      const h3 = document.querySelector('h3.profile-card-name.text-heading-large');
      const txt = h3 ? (h3.textContent || '').trim() : '';
      if (txt) return txt;
    } catch {}
    return new Promise(resolve => {
      chrome.storage.local.get(['user'], st => {
        const n = st && st.user && st.user.name;
        resolve((n || '').trim());
      });
    });
  }

  // Communication avec popup
  chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
    if (msg.action === 'ping') { sendResponse({ status: 'ok' }); return true; }
    if (msg.action === "stop") {
      stopRequested = true;
      console.log("Stop demandé !");
      sendResponse({ status: "stopped" });
      return true;
    }  

    if (msg.action === "saveProfile") {
      currentProfileData = msg.profileData || {};
      //console.log("Profil reçu : ", currentProfileData);
      sendResponse({ status: "profile_saved" });
      return true;
    }

    if (msg.action === "like") {
      stopRequested = false;
      autoLikePosts(msg.count || 1).then(r => sendResponse({ status: "ok", result: r }));
      return true;
    }

    if (msg.action === "comment") {
      stopRequested = false;
      autoCommentPosts(msg.count || 1, msg.profileData || {}).then(r => sendResponse({ status: "ok", result: r }));
      return true;
    }

    if (msg.action === "likeComment") {
      stopRequested = false;
      autoLikeCommentPosts(msg.count || 1, msg.profileData || {}).then(r => sendResponse({ status: "ok", result: r }));
      return true;
    }

    // New: extract profile data from current LinkedIn page for onboarding/persona
    if (msg.action === "extract_profile") {
      (async () => {
        try {
          const raw = await extractLinkedInProfile(msg.options || {});
          sendResponse({ status: "ok", data: raw });
        } catch (e) {
          sendResponse({ status: "error", error: String(e && e.message || e) });
        }
      })();
      return true;
    }

    // New: navigate to the user's profile page then extract
    if (msg.action === "open_profile_and_extract") {
      (async () => {
        try {
          await ensureProfilePage();
          // Give LinkedIn a moment to hydrate profile DOM
          await sleepStoppable(1200);
          const raw = await extractLinkedInProfileExhaustive(msg.options || {});
          sendResponse({ status: "ok", data: raw });
        } catch (e) {
          sendResponse({ status: "error", error: String(e && e.message || e) });
        }
      })();
      return true;
    }

    // New: extraction exhaustive sans navigation (utilisée par le flow après chargement complet)
    if (msg.action === "extract_profile_exhaustive") {
      (async () => {
        try {
          const raw = await extractLinkedInProfileExhaustive(msg.options || {});
          sendResponse({ status: "ok", data: raw });
        } catch (e) {
          sendResponse({ status: "error", error: String(e && e.message || e) });
        }
      })();
      return true;
    }

    // Return the best guess profile URL (or current URL if already on profile), with small retries
    if (msg.action === "get_profile_href") {
      (async () => {
        try {
          let href = null;
          for (let i = 0; i < 8; i++) {
            href = findProfileHref();
            if (href) break;
            await sleepStoppable(250);
          }
          sendResponse({ status: href ? 'ok' : 'not_found', href });
        } catch (e) {
          sendResponse({ status: 'error', error: String(e && e.message || e) });
        }
      })();
      return true;
    }

    // Check if current page is a LinkedIn 404 or not found page
    if (msg.action === 'check_not_found') {
      try {
        sendResponse({ notFound: isNotFoundPage(), href: location.href });
      } catch (e) {
        sendResponse({ notFound: false, error: String(e && e.message || e) });
      }
      return true;
    }

    // Auto reply sniper
    if (msg.action === "replySniper") {
      stopRequested = false;
      autoReplySniper(msg.count || 1, msg.profileData || {}, msg.options || {})
        .then(r => sendResponse({ status: "ok", result: r }))
        .catch(e => sendResponse({ status: 'error', error: String(e && e.message || e) }));
      return true;
    }
  });

  function insertCliasoMenuButton() {
    const menu = document.querySelector('ul.global-nav__primary-items');
    if (!menu) return;
    if (document.querySelector("#cliaso-menu-button")) return;

    const li = document.createElement("li");
    li.className = "global-nav__primary-item";
    li.id = "cliaso-menu-button";
    li.style.position = "relative";

    li.innerHTML = `
      <a class="global-nav__primary-link" href="#" target="_self">
        <div class="ivm-image-view-model global-nav__icon-ivm">
          <div class="ivm-view-attr__img-wrapper">
            <li-icon aria-hidden="true" type="custom-icon" class="ivm-view-attr__icon" size="large">
              <img src="${chrome.runtime.getURL('assets/icon/launch.png')}" alt="Lancement" width="24" height="24" style="border-radius: 6px;"/>
            </li-icon>
          </div>
        </div>
        <span class="t-12 break-words block t-black--light t-normal global-nav__primary-link-text" title="Ocalis">
          Ocalis
        </span>
      </a>

      <div class="cliaso-submenu" style="
        display: none;
        position: absolute;
        top: 100%;
        right: 0;
        width: 50vw;
        max-width: 540px; 
        min-width: 400px; 
        height: 90vh;
        background: #fff;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        border-radius: 8px;
        z-index: 9999;
        overflow: hidden;
      ">
        <iframe src="${chrome.runtime.getURL('popup.html')}" style="border:none;width:100%;height:100%;border-radius:8px;"></iframe>
      </div>
    `;

    const notifications = menu.querySelector('li.global-nav__primary-item a[href*="/notifications/"]');
    if (notifications) {
      notifications.parentNode.insertBefore(li, notifications.nextSibling);
    } else {
      menu.appendChild(li);
    }

    const link = li.querySelector("a");
    const submenu = li.querySelector(".cliaso-submenu");
    const iframe = submenu.querySelector("iframe");

    link.addEventListener("click", (e) => {
      e.preventDefault();
      const isClosed = (submenu.style.display === "none" || submenu.style.display === "");
      submenu.style.display = isClosed ? "block" : "none";
    });

    document.addEventListener("click", (e) => {
      if (!li.contains(e.target)) {
        submenu.style.display = "none";
      }
    });
  }

  function injectCliasoCommentButtons() {
    const posts = document.querySelectorAll(".feed-shared-update-v2, .occludable-update");

    posts.forEach(post => {
      const formMain = Array.from(post.querySelectorAll('form.comments-comment-box__form'))
        .find(f => !f.closest('.comments-comment-entity'));
      if (!formMain) return;
      if (formMain.querySelector(".cliaso-comment-btn")) return;

      const photoButton = formMain.querySelector(
        'button[aria-label="Ajouter une photo"], button[aria-label="Add a photo"]'
      );      

      if (photoButton) {
        const cliasoBtn = document.createElement("button");
        cliasoBtn.type = "button";
        cliasoBtn.className = "artdeco-button artdeco-button--muted artdeco-button--2 artdeco-button--tertiary cliaso-comment-btn";
        cliasoBtn.style.marginLeft = "4px";
        cliasoBtn.innerHTML = `
          <img src="${chrome.runtime.getURL("assets/icon/launch.png")}" alt="Ocalis" width="20" height="20" style="border-radius: 6px;"/>
          <span class="artdeco-button__text" style="font-size: 1.4rem; margin-left:6px;">Générer avec Ocalis</span>
        `;

        // Ajouter après le bouton photo
        photoButton.parentNode.insertBefore(cliasoBtn, photoButton.nextSibling);
        try {
          const lbl = (typeof t === 'function') ? t('generate_with_ocalis') : null;
          if (lbl) {
            const el = cliasoBtn.querySelector('.artdeco-button__text');
            if (el) el.textContent = lbl;
          }
        } catch {}

        // Action au clic
        cliasoBtn.addEventListener("click", async (e) => {
          e.preventDefault();

          const textarea = formMain.querySelector("div[role='textbox']");
          if (!textarea) return;
          
          const profileData = currentProfileData || {};
            
          const postText = post.innerText || "";
          const bodyData = { post: postText, profile: profileData }; 

          try {
            const resp = await apiFetchContent("/comment", {
              method: "POST",
              body: JSON.stringify(bodyData),
            });

            const data = await resp.json();

            if (!resp.ok) {
              // Quota dépassé
              if (data.error === "quota_reached") {
                chrome.storage.local.set({ quota: data.quota_restant, mode: data.mode });
                console.log("[Auto Comment] Quota journalier atteint :", data.quota_restant);
                throw new Error("STOP");
              }

              throw new Error(
                "Vérifiez si vous êtes connecté(e) à  Ocalis. Sinon, veuillez contacter l'administrateur."
              );
            }

            // Gestion quotas + mode
            if (data.unlimited) {
              if (data.mode === "free_trial") {
                chrome.storage.local.set({ quota: "illimité (essai gratuit)", mode: data.mode });
                console.log("[Auto Comment] Quota illimité pendant l'essai gratuit");
              } else if (data.mode === "gold_unlimited") {
                chrome.storage.local.set({ quota: "illimité", mode: data.mode });
                console.log("[Auto Comment] Quota illimité (gold)");
              }
            } else {
              chrome.storage.local.set({ quota: data.quota_restant, mode: data.mode });
              console.log("[Auto Comment] Quota restant :", data.quota_restant);
            }

            const rawComment = data.comment || "";
            const comment = normalizeComment(rawComment);

            textarea.focus();
            textarea.textContent = comment;
            textarea.dispatchEvent(new Event("input", { bubbles: true }));
          } catch (err) {
            console.error("Erreur génération commentaire :", err);
          }
        });
      }
    });
  }

  // Inject "Generer avec Ocalis" button into reply composers (under comments)
  function injectCliasoReplyButtons(scope) {
    try {
      const root = scope || document;
      const forms = Array.from(root.querySelectorAll('form.comments-comment-box__form'));
      for (const form of forms) {
        // Only target reply composers attached to an existing comment, not the top-level post composer
        const underComment = form.closest('.comments-comment-entity');
        if (!underComment) continue;
        if (form.querySelector('.cliaso-reply-btn, .cliaso-comment-btn')) continue;

        // Try to anchor next to the photo button or in the detour container
        const photoBtn = form.querySelector('button[aria-label="Ajouter une photo"], button[aria-label="Add a photo"]');
        const detour = form.querySelector('.comments-comment-box__detour-container');

        const btn = document.createElement('button');
        btn.type = 'button';
        btn.className = 'artdeco-button artdeco-button--muted artdeco-button--2 artdeco-button--tertiary cliaso-reply-btn';
        btn.style.marginLeft = '4px';
        btn.innerHTML = `
          <img src="${chrome.runtime.getURL('assets/icon/launch.png')}" alt="Ocalis" width="20" height="20" style="border-radius: 6px;"/>
          <span class="artdeco-button__text" style="font-size: 1.4rem; margin-left:6px;">G\u00E9n\u00E9rer avec Ocalis</span>
        `;
        try {
          const lbl = (typeof t === 'function') ? t('generate_with_ocalis') : null;
          if (lbl) {
            const el = btn.querySelector('.artdeco-button__text');
            if (el) el.textContent = lbl;
          }
        } catch {}

        if (photoBtn && photoBtn.parentNode) {
          photoBtn.parentNode.insertBefore(btn, photoBtn.nextSibling);
        } else if (detour) {
          detour.appendChild(btn);
        } else {
          form.appendChild(btn);
        }

        btn.addEventListener('click', async (e) => {
          e.preventDefault();
          try {
            const postEl = form.closest('.feed-shared-update-v2, .occludable-update, article') || document;
            await replyToComment(underComment, postEl, currentProfileData || {}, undefined, { submit: false });
          } catch (err) {
            console.warn('[Reply Helper] generation error:', err);
          }
        });
      }
    } catch {}
  }

  function normalizeComment(raw) {
    let v = raw;
    try {
      // boucle d'extraction si serveur renvoie une string qui contient JSON
      for (let i = 0; i < 8; i++) {
        if (typeof v !== "string") break;
        const s = v.trim();
        if (s.startsWith("{") || s.startsWith('"') || s.startsWith("'")) {
          try {
            const parsed = JSON.parse(s);
            if (parsed && typeof parsed === "object") {
              if (typeof parsed.comment === "string") {
                v = parsed.comment;
                continue;
              } else if (typeof parsed.reply === "string") {
                v = parsed.reply;
                continue;
              } else {
                // si objet sans champ utile -> on stop
                break;
              }
            } else {
              // parsed n'est pas objet -> on l'utilise (string/number)
              v = parsed;
              continue;
            }
          } catch (e) {
            break;
          }
        } else {
          break;
        }
      }
    } catch (e) {
      // noop
    }
    if (typeof v !== "string") v = String(v || "");
    return v;
  }

  async function apiFetchContent(path, opts = {}) {
    return new Promise((resolve, reject) => {
      chrome.storage.local.get(['accessToken','refreshToken'], async (st) => {
        let headers = opts.headers || {};
        if (st.accessToken) headers['Authorization'] = `Bearer ${st.accessToken}`;
        headers['Content-Type'] = headers['Content-Type'] || 'application/json';

        try {
          let res = await fetch("https://app.cliaso.com/lnapi" + path, { ...opts, headers });

          if (res.status === 401 && st.refreshToken) {
            // refresh JWT si expiré
            const r = await fetch("https://app.cliaso.com/lnapi/auth/refresh", {
              method: "POST",
              headers: { 'Content-Type': 'application/json' },
              body: JSON.stringify({ refreshToken: st.refreshToken })
            });

            if (r.ok) {
              const j = await r.json();
              await chrome.storage.local.set({ accessToken: j.accessToken });
              headers['Authorization'] = `Bearer ${j.accessToken}`;
              res = await fetch("https://app.cliaso.com/lnapi" + path, { ...opts, headers });
            } else {
              // refresh échoué -> logout
              await chrome.storage.local.remove(['accessToken','refreshToken','user']);
              return reject(new Error("Token expiré et refresh échoué"));
            }
          }

          resolve(res);

        } catch (err) {
          reject(err);
        }
      });
    });
  }

  async function getLikeSelectors() {
    try {
      const res = await apiFetchContent("/like-selectors", { method: "GET" });
      if (!res.ok) throw new Error("Impossible de récupérer les sélecteurs");

      const json = await res.json();
      let selectors = json.selectors;

      selectors = selectors.map(s => s.normalize("NFC"));

      return selectors;

    } catch (err) {
      console.error("âŒ Erreur getLikeSelectors:", err);
      return [];
    }
  }

  function initObserver() {
    const body = document.body;

    if (!body) {
      setTimeout(initObserver, 100);
      return;
    }

    const observer = new MutationObserver(() => {
      insertCliasoMenuButton();
      injectCliasoCommentButtons();
      injectCliasoReplyButtons();
    });

    observer.observe(body, { childList: true, subtree: true });

    // Premier appel direct
    insertCliasoMenuButton();
    injectCliasoCommentButtons();
    injectCliasoReplyButtons();

    console.log("Observer Cliaso installé");
  }

  initObserver();

  // ================= Persona extraction helpers =================
  function cleanText(s) {
    return (s || "").replace(/\s+/g, " ").trim();
  }

  function pickFirstText(selectors) {
    for (const sel of selectors) {
      const el = document.querySelector(sel);
      if (el) return cleanText(el.textContent || "");
    }
    return "";
  }

  function isProfilePageLike(url) {
    try {
      const u = new URL(url || location.href);
      return /\/in\//.test(u.pathname) || /recent-activity/.test(u.pathname);
    } catch { return false; }
  }

  async function extractLinkedInProfile(options = {}) {
    const maxPosts = Math.max(1, Math.min(30, options.maxPosts || 20));

    const headline = pickFirstText([
      '.pv-text-details__left-panel .text-body-medium.break-words',
      '.pv-top-card .text-body-medium.break-words',
      'h2.text-body-medium.break-words',
      '[data-test-id="top-card-headline"]',
      '[data-test-top-card-headline]'
    ]);

    let about = "";
    try {
      const sections = Array.from(document.querySelectorAll('section'));
      for (const sec of sections) {
        const h = (sec.querySelector('h2, h3, header') || {}).textContent || "";
        if (/about|à  propos|a propos|info/i.test(h)) {
          const t = sec.querySelector('.inline-show-more-text, .pv-shared-text-with-see-more, p, span');
          if (t && cleanText(t.textContent)) { about = cleanText(t.textContent); break; }
        }
      }
    } catch {}

    // Collect visible posts (generic selectors to work on profile activity or feed)
    const posts = [];
    const postEls = Array.from(document.querySelectorAll('.feed-shared-update-v2, .occludable-update, article'));
    for (const el of postEls) {
      if (posts.length >= maxPosts) break;
      const txtEl = el.querySelector('[data-test-id="post-content"], .feed-shared-update-v2__description, div[dir="ltr"], span[dir="ltr"], p');
      const txt = cleanText((txtEl && txtEl.textContent) || el.textContent || "");
      if (txt && txt.length > 20) posts.push(txt);
    }

    // Collect visible comments if any
    const comments = [];
    const comEls = Array.from(document.querySelectorAll('[data-test-comment], .comments-comment-item-content-body, .comments-comment-item__main-content, .comments-comments-list'));
    for (const el of comEls) {
      if (comments.length >= maxPosts) break;
      const txt = cleanText(el.textContent || "");
      if (txt && txt.length > 10) comments.push(txt);
    }

    const pageUrl = location.href;
    const id = isProfilePageLike(pageUrl) ? ('author:' + (new URL(pageUrl)).pathname) : ('page:' + (new URL(pageUrl)).pathname);

    // Also grab profile name if available
    const name = pickFirstText([
      '.pv-text-details__left-panel h1',
      '.pv-top-card h1',
      'h1.text-heading-xlarge'
    ]);

    return {
      id,
      name,
      headline,
      about,
      posts,
      comments,
      url: pageUrl,
      ts: Date.now()
    };
  }

  // Exhaustive extraction with visible scrolling and optional comment expansion
  async function extractLinkedInProfileExhaustive(options = {}) {

    console.log(" [Extractor] Starting hybrid profile extraction...");

    const fastCfg = {
      minPosts: 10,
      maxPosts: 10,
      minComments: 10,
      maxComments: 10,
      maxScrolls: 5,
      interScrollDelayMs: 200
    };

    const slowCfg = {
      minPosts: 10,
      maxPosts: 10,
      minComments: 10,
      maxComments: 10,
      maxScrolls: 20,
      maxNoGrowthStreak: 3,
      timeBudgetMs: 15000,
      interScrollDelayMs: 400
    };

    const t0 = Date.now();

    // --- Phase 1: Fast Mode ---
    console.log(" [Fast Mode] Trying quick extraction...");
    let data = await runExtractor(fastCfg, 5000);
    if (data.posts.length >= fastCfg.minPosts && data.comments.length >= fastCfg.minComments) {
      const duration = Date.now() - t0;
      console.log(` [Fast Mode] Success in ${duration}ms → ${data.posts.length} posts, ${data.comments.length} comments.`);
      return { ...data, mode: "fast" };
    }
    console.log(` [Fast Mode] Not enough data → ${data.posts.length} posts, ${data.comments.length} comments.`);

    // --- Phase 2: Slow Mode ---
    console.log(" [Slow Mode] Switching to deep extraction...");
    data = await runExtractor(slowCfg, slowCfg.timeBudgetMs);
    const duration = Date.now() - t0;
    console.log(` [Slow Mode] Done in ${duration}ms → ${data.posts.length} posts, ${data.comments.length} comments.`);
    return { ...data, mode: "slow" };
  }

  // --- Worker function (common logic) ---
  async function runExtractor(cfg, maxTimeMs) {
    let snapshot = snapshotProfile();
    let posts = new Set(snapshot.posts || []);
    let comments = new Set(snapshot.comments || []);
    const openedForComments = new WeakSet();

    let scrolls = 0;
    let noGrowthStreak = 0;
    let prevSizes = { posts: posts.size, comments: comments.size };
    let prevHeight = document.body?.scrollHeight || 0;
    const t0 = Date.now();

    if (comments.size < cfg.minComments) {
      try {
        await expandCommentsOnVisiblePosts(3, openedForComments);
        snapshot = snapshotProfile();
        snapshot.comments?.forEach(c => comments.add(c));
      } catch {}
    }

    while ((posts.size < cfg.minPosts || comments.size < cfg.minComments) && scrolls < cfg.maxScrolls) {
      await humanLikeStepScroll();
      await sleepStoppable(cfg.interScrollDelayMs);
      scrolls++;
      console.log(`ðŸ”„ Scroll #${scrolls} → ${posts.size} posts, ${comments.size} comments`);

      if (comments.size < cfg.minComments && scrolls % 2 === 0) {
        try { await expandCommentsOnVisiblePosts(2, openedForComments); } catch {}
      }

      const snap = snapshotProfile();
      snap.posts?.forEach(p => posts.add(p));
      snap.comments?.forEach(c => comments.add(c));

      // Growth check
      const newSizes = { posts: posts.size, comments: comments.size };
      const newHeight = document.body?.scrollHeight || 0;
      const grew = newSizes.posts > prevSizes.posts || newSizes.comments > prevSizes.comments || newHeight > prevHeight;

      if (!grew && ++noGrowthStreak >= (cfg.maxNoGrowthStreak || Infinity)) {
        console.log("No growth detected after multiple scrolls → stopping.");
        break;
      }
      if (grew) {
        noGrowthStreak = 0;
        prevSizes = newSizes;
        prevHeight = newHeight;
      }

      if (Date.now() - t0 > maxTimeMs) {
        console.log("â° Time budget exceeded → stopping.");
        break;
      }
      if (stopRequested) throw new Error("STOP");
    }

    const finalSnap = snapshotProfile();
    return {
      id: finalSnap.id,
      name: finalSnap.name,
      headline: finalSnap.headline,
      about: finalSnap.about,
      posts: Array.from(posts).slice(0, cfg.maxPosts),
      comments: Array.from(comments).slice(0, cfg.maxComments),
      url: finalSnap.url,
      ts: Date.now()
    };
  }

  async function goToActivityTab() {
    try {
      const link = document.querySelector('a[href*="recent-activity"], a[href*="activities"], a[href*="/detail/recent-activity/"]');
      if (link) {
        link.click();
        await sleepStoppable(900);
      }
    } catch {}
  }

  function snapshotProfile() {
    const headline = pickFirstText([
      '.pv-text-details__left-panel .text-body-medium.break-words',
      '.pv-top-card .text-body-medium.break-words',
      'h2.text-body-medium.break-words',
      '[data-test-id="top-card-headline"]',
      '[data-test-top-card-headline]'
    ]);

    let about = "";
    try {
      const sections = Array.from(document.querySelectorAll('section'));
      for (const sec of sections) {
        const h = (sec.querySelector('h2, h3, header') || {}).textContent || "";
        if (/about|à  propos|a propos|info/i.test((h||'').toLowerCase())) {
          const t = sec.querySelector('.inline-show-more-text, .pv-shared-text-with-see-more, p, span');
          if (t && cleanText(t.textContent)) { about = cleanText(t.textContent); break; }
        }
      }
    } catch {}

    const posts = [];
    const postEls = Array.from(document.querySelectorAll('.feed-shared-update-v2, .occludable-update, article'));
    for (const el of postEls) {
      const txtEl = el.querySelector('[data-test-id="post-content"], .feed-shared-update-v2__description, div[dir="ltr"], span[dir="ltr"], p');
      const txt = cleanText((txtEl && txtEl.textContent) || el.textContent || "");
      if (txt && txt.length > 20) posts.push(txt);
    }

    const comments = [];
    const comEls = Array.from(document.querySelectorAll('[data-test-comment], .comments-comment-item-content-body, .comments-comment-item__main-content, .comments-comments-list, .comments-post-meta__actor-meta'));
    for (const el of comEls) {
      const txt = cleanText(el.textContent || "");
      if (txt && txt.length > 10) comments.push(txt);
    }

    const pageUrl = location.href;
    const id = isProfilePageLike(pageUrl) ? ('author:' + (new URL(pageUrl)).pathname) : ('page:' + (new URL(pageUrl)).pathname);
    const name = pickFirstText([
      '.pv-text-details__left-panel h1', '.pv-top-card h1', 'h1.text-heading-xlarge'
    ]);
    return { id, name, headline, about, posts, comments, url: pageUrl };
  }

  async function expandCommentsOnVisiblePosts(maxToOpen = 2, openedSet) {
    const posts = Array.from(document.querySelectorAll('.feed-shared-update-v2, .occludable-update, article'));
    let opened = 0;
    for (const post of posts) {
      if (opened >= maxToOpen) break;
      if (openedSet && openedSet.has(post)) continue;
      // try to click comment button to load the comment box and existing comments
      const btn = post.querySelector('button[aria-label*="Comment"], button[aria-label*="Commenter"], button[data-control-name="comment"]');
      if (btn) {
        try {
          await scrollToElement(btn);
          btn.click();
          opened++;
          if (openedSet) openedSet.add(post);
          await sleepStoppable(700 + Math.random()*500);
          // Also try to expand more comments if a button exists
          const more = post.querySelector('button[aria-label*="Afficher" i], button[aria-label*="Voir" i], button[data-control-name*="comments"]');
          if (more) {
            try { more.click(); await sleepStoppable(600 + Math.random()*400); } catch {}
          }
        } catch {}
      }
    }
  }

  async function ensureProfilePage(timeoutMs = 7000) {
    if (isProfilePageLike(location.href)) return true;
    const t0 = performance.now();

    // Try to find a profile link in the global nav
    const tryFindProfileHref = () => {
      const candidates = Array.from(document.querySelectorAll(
        'a[href*="/in/"]'
      ));
      const best = candidates.find(a => /\/in\//.test(a.getAttribute('href') || ""));
      return best ? new URL(best.href, location.origin).href : null;
    };

    let href = tryFindProfileHref();
    if (!href) {
      // Open the Me menu to reveal profile link if possible
      const meBtn = document.querySelector('button.global-nav__me, .global-nav__me-photo, img.global-nav__me-photo');
      if (meBtn) {
        meBtn.click();
        await sleepStoppable(400);
        href = tryFindProfileHref();
      }
    }

    if (href) {
      location.assign(href);
    }

    // Wait until we are on /in/ page or timeout
    while (performance.now() - t0 < timeoutMs) {
      if (isProfilePageLike(location.href)) break;
      await sleepStoppable(250);
    }
    return isProfilePageLike(location.href);
  }

  function findProfileHref() {
    if (isProfilePageLike(location.href)) return location.href;
    const candidates = Array.from(document.querySelectorAll('a[href*="/in/"]'));
    const best = candidates.find(a => /\/in\//.test(a.getAttribute('href') || ""));
    return best ? new URL(best.href, location.origin).href : null;
  }

  function isNotFoundPage() {
    try {
      const t = (document.title || '').toLowerCase();
      const body = document.body ? (document.body.innerText || '').toLowerCase() : '';
      const patterns = [
        /page not found/, /doesn['â€™]t exist/, /this page doesn['â€™]t exist/,
        /cette page n['â€™]existe pas/, /page introuvable/, /erreur\s*404/, /\b404\b/
      ];
      return patterns.some(rx => rx.test(t) || rx.test(body));
    } catch { return false; }
  }

  function personaToProfileData(p) {
    if (!p) return {};
    const style = (p.litteraire && p.litteraire.lexique ? p.litteraire.lexique.slice(0,8).join(', ') : '') +
                  (p.litteraire && p.litteraire.structures ? ('; ' + p.litteraire.structures.join(', ')) : '');
    const tone = (p.recommandations_generation && p.recommandations_generation.variabilité) || 'neutre';
    const length = (p.recommandations_generation && p.recommandations_generation.longueur) || '1 à  3 phrases';
    const forbidden = (p.interdits || []).join(', ');
    return { style, tone, length, forbidden };
  }

  })();
}

// i18n: keep cliaso button label translated if dictionary is available
(function(){
  try{
    const obs = new MutationObserver(() => {
      const lbl = (typeof t === 'function') ? t('generate_with_ocalis') : null;
      if (!lbl) return;
      document.querySelectorAll('.cliaso-comment-btn .artdeco-button__text').forEach(el => {
        try { if (el.textContent !== lbl) el.textContent = lbl; } catch{}
      });
    });
    obs.observe(document.documentElement, { childList: true, subtree: true });
  } catch(_){}
})();
