// IMPORTANT: Local analysis is disabled. Only backend results are authoritative.
// If called, we return a minimal persona with meta only, without style/ton/length/interdits.
function buildPersona(raw) {
  if (!raw) return null;
  const hasAny = !!(raw.headline || raw.about || (raw.posts && raw.posts.length) || (raw.comments && raw.comments.length));
  if (!hasAny) return null;
  return {
    persona: {
      id: raw.id || 'author-unknown',
      meta: { name: raw.name || '', source: raw.url || '', ts: raw.ts || Date.now() }
    }
  };
}

function tokenize(text) {
  const t = (text || "").toLowerCase().normalize("NFKD").replace(/[\u0300-\u036f]/g, "");
  const words = t.match(/[a-zàâäéèêëïîôöùûüç0-9']+/gi) || [];
  const stop = new Set([
    'a','au','aux','avec','ce','ces','dans','de','des','du','elle','en','et','eux','il','je','la','le','les','leur','lui','ma','mais','me','meme','mes','moi','mon','ne','nos','notre','nous','on','ou','par','pas','pour','qu','que','qui','sa','se','ses','son','sur','ta','te','tes','toi','ton','tu','un','une','vos','votre','vous','c','d','j','l','s','t','y','ete','etions','etes','suis','sommes','etes','sont','etre','ete','avoir','ai','as','avons','avez','ont','fait','faites','fais','faisons','font'
  ]);
  return words.filter(w => w.length > 2 && !stop.has(w));
}

function wordFreq(tokens) {
  const f = Object.create(null);
  for (const w of tokens) f[w] = (f[w] || 0) + 1;
  return f;
}

function sentenceStats(text) {
  const sentences = (text || "").split(/[.!?]+\s+/).filter(Boolean);
  const words = sentences.map(s => (s.trim().split(/\s+/).filter(Boolean).length));
  const avg = words.length ? (words.reduce((a,b)=>a+b,0)/words.length) : 0;
  const points = (text.match(/[.!?]/g) || []).length;
  const suspension = /\.\.\./.test(text) ? 'occasionnels' : 'rares';
  return { avgSentenceLen: avg, punctuation: { points }, hasQuestion: /\?/.test(text), hasExclamation: /!/.test(text), suspension };
}

function detectEmojis(text) {
  const m = (text || "").match(/[\p{Emoji_Presentation}\p{Emoji}\uFE0F]/gu) || [];
  return { count: m.length };
}

function pickByKeywords(freq, dict, max, fallback) {
  const scores = [];
  for (const [label, keys] of Object.entries(dict)) {
    let s = 0;
    for (const k of keys) {
      for (const [w, c] of Object.entries(freq)) {
        if (w.includes(k)) s += c;
      }
    }
    scores.push([label, s]);
  }
  scores.sort((a,b)=>b[1]-a[1]);
  const picked = scores.filter(x=>x[1]>0).slice(0, max).map(x=>x[0]);
  if (picked.length < max) {
    for (const x of fallback) if (!picked.includes(x) && picked.length < max) picked.push(x);
  }
  return picked;
}

// Export to window
window.OcalisAnalysis = { buildPersona };
