(async () => {
  const personaObj = await OcalisFlow.loadPersona();
  const p = personaObj && personaObj.persona;
  if (!p) return;

  // Psychologie → on prend tous les champs utiles
  const psychParts = [];
  if (p.psychologie) {
    psychParts.push(...(p.psychologie.valeurs || []).slice(0,3));
    psychParts.push(...(p.psychologie.peurs || []).slice(0,3));
    psychParts.push(...(p.psychologie.drivers || []).slice(0,3));
    if (p.psychologie.rapport_a_echec) psychParts.push(p.psychologie.rapport_a_echec);
    if (p.psychologie.relation_aux_autres) psychParts.push(p.psychologie.relation_aux_autres);
    if (p.psychologie.positionnement) psychParts.push(p.psychologie.positionnement);
    if (p.psychologie.temperament) psychParts.push(p.psychologie.temperament);
    if (p.psychologie.intensite) psychParts.push(p.psychologie.intensite);
    if (p.psychologie.vulnerabilite) psychParts.push(p.psychologie.vulnerabilite);
    if (p.psychologie.energie) psychParts.push(p.psychologie.energie);
  }

  OcalisFlow.setText('psych', psychParts.join(', '));

  // Littéraire
  OcalisFlow.setText('lit',
    (p.litteraire.lexique || []).slice(0,3).join(', ') +
    ((p.litteraire.structures || [])[0] || '')
  );

  // Interdits
  OcalisFlow.setText('ban', (p.interdits || []).slice(0,3).join(', '));
})();

document.getElementById('next').addEventListener('click', ()=> OcalisFlow.go('step4_validate.html'));

