const editBtn = document.getElementById('edit');
const pane = document.getElementById('editPane');
const forb = document.getElementById('forb');
const styleEl = document.getElementById('style');
const toneEl = document.getElementById('tone');
const ok = document.getElementById('ok');
const save = document.getElementById('save');

/** Hydrate les champs à partir du persona ou du profileData */
async function hydrateFields() {
  const personaObj = await OcalisFlow.loadPersona();
  const p = personaObj && personaObj.persona;

  if (p) {
    forb.value = (p.interdits || []).join(', ');

    const lexique = (p.litteraire?.lexique || []).join(', ');
    const structures = (p.litteraire?.structures || []).join(', ');
    styleEl.value = [lexique, structures].filter(Boolean).join('; ');

    const toneParts = [];
    if (p.psychologie) {
      toneParts.push(...(p.psychologie.valeurs || []));
      toneParts.push(...(p.psychologie.peurs || []));
      toneParts.push(...(p.psychologie.drivers || []));
      if (p.psychologie.rapport_a_echec) toneParts.push(p.psychologie.rapport_a_echec);
      if (p.psychologie.relation_aux_autres) toneParts.push(p.psychologie.relation_aux_autres);
      if (p.psychologie.positionnement) toneParts.push(p.psychologie.positionnement);
      if (p.psychologie.temperament) toneParts.push(p.psychologie.temperament);
      if (p.psychologie.intensite) toneParts.push(p.psychologie.intensite);
      if (p.psychologie.vulnerabilite) toneParts.push(p.psychologie.vulnerabilite);
      if (p.psychologie.energie) toneParts.push(p.psychologie.energie);
    }
    if (p.recommandations_generation?.variabilité) {
      toneParts.push(p.recommandations_generation.variabilité);
    }

    toneEl.value = toneParts.join(', ');
  } else {
    // fallback profileData
    try {
      const pd = JSON.parse(localStorage.getItem('profileData') || '{}');
      styleEl.value = pd.style || '';
      toneEl.value = pd.tone || '';
      forb.value = pd.forbidden || '';
    } catch {}
  }
}

/** Sauvegarde persona + profileData */
async function saveProfileData() {
  const personaObj = await OcalisFlow.loadPersona();
  if (!personaObj?.persona) return;
  const p = personaObj.persona;

  // Interdits
  p.interdits = forb.value.split(',').map(s => s.trim()).filter(Boolean);

  // Style
  const parts = (styleEl.value || '').split(';').map(s => s.trim()).filter(Boolean);
  p.litteraire = p.litteraire || {};
  p.litteraire.lexique = parts[0] ? parts[0].split(',').map(s => s.trim()).filter(Boolean) : (p.litteraire.lexique || []);
  p.litteraire.structures = parts[1] ? parts[1].split(',').map(s => s.trim()).filter(Boolean) : (p.litteraire.structures || []);

  // Ton
  p.recommandations_generation = p.recommandations_generation || {};
  p.recommandations_generation.variabilité = toneEl.value || p.recommandations_generation.variabilité || '';

  await new Promise(r => chrome.storage.local.set({ persona: personaObj }, r));

  // profileData
  const styleText = [(p.litteraire.lexique || []).join(', '), (p.litteraire.structures || []).join(', ')].filter(Boolean).join('; ');
  const profileData = {
    style: styleText,
    tone: toneEl.value || '',
    forbidden: (p.interdits || []).join(', ')
  };
  localStorage.setItem('profileData', JSON.stringify(profileData));
}

/** Initialisation */
(async () => {
  await hydrateFields(); 
})();

/** Edit pane toggle */
editBtn.addEventListener('click', async () => {
  await hydrateFields(); // recharge les valeurs actuelles
  pane.classList.toggle('hidden');
});

/** Valider */
ok.addEventListener('click', async () => {
  await saveProfileData();
  const personaObj = await OcalisFlow.loadPersona();
  if (personaObj?.persona) {
    personaObj.persona.validated = true;
    await new Promise(r => chrome.storage.local.set({ persona: personaObj }, r));
  }
  OcalisFlow.go('step5_activate.html');
});

/** Enregistrer */
save.addEventListener('click', async () => {
  await saveProfileData();
  OcalisFlow.go('step5_activate.html');
});
