function personaToProfileData(p) {
  if (!p) return {};
  const style = (p.litteraire && p.litteraire.lexique ? p.litteraire.lexique.slice(0,8).join(', ') : '') +
                (p.litteraire && p.litteraire.structures ? ('; ' + p.litteraire.structures.join(', ')) : '');
  const tone = (p.recommandations_generation && p.recommandations_generation.variabilité) || 'neutre';
  const length = (p.recommandations_generation && p.recommandations_generation.longueur) || '1 à 3 phrases';
  const forbidden = (p.interdits || []).join(', ');
  return { style, tone, length, forbidden };
}

document.getElementById('activate').addEventListener('click', async () => {
  const personaObj = await OcalisFlow.loadPersona();
  if (personaObj && personaObj.persona) {
    try { localStorage.setItem('profileData', JSON.stringify(personaToProfileData(personaObj.persona))); } catch {}
  }
  await new Promise(r => chrome.storage.local.set({ persona_active: true }, r));
  const tab = await OcalisFlow.getActiveLinkedInTab();
  if (tab) {
    chrome.tabs.update(tab.id, {
      active: true,
      url: "https://www.linkedin.com/feed/"
    });
  }
  window.close();
});

